/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModeloComprobantesAnulados
implements ModeloValores {
    private boolean inicializado;
    private final Map<String, ElementoNombreValor<String>> tiposDeComprobantes = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private Periodo periodo;

    public ModeloComprobantesAnulados(Periodo periodo) {
        this.periodo = periodo;
    }

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarTiposDeComprobantes();
            this.inicializado = true;
        }
    }

    private void cargarTiposDeComprobantes() {
        this.tiposDeComprobantes.clear();
        Map comprobantes = UtilCatalogosATS.crearInstancia().obtenerComprobantesPorPeriodo(this.periodo.getAnio(), this.periodo.getMes());
        for (Map.Entry comp : comprobantes.entrySet()) {
            this.tiposDeComprobantes.put((String)comp.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor(String.valueOf((String)comp.getKey()) + "-" + (String)comp.getValue(), (Object)((String)comp.getKey())));
        }
        if (this.periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            this.tiposDeComprobantes.remove("13");
            this.tiposDeComprobantes.remove("14");
            this.tiposDeComprobantes.remove("17");
            this.tiposDeComprobantes.remove("40");
        }
    }

    public List<ElementoNombreValor<String>> getTiposDeComprobantes() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposDeComprobantes.values());
    }

    public ElementoNombreValor<String> obtenerTipoComprobante(String codigoTipoComprobante) {
        return StringUtil.isNullOrEmpty((String)codigoTipoComprobante) ? null : this.tiposDeComprobantes.get(codigoTipoComprobante);
    }
}

